namespace Takmicenje 
{
    public class Program
    {
        public static void Main(string[] args)
        {
            string[] input = Console.ReadLine().Split(' ');
            int n = int.Parse(input[0]), k = int.Parse(input[1]);

            Runner[] runners = new Runner[n];
            bool[,] passMatrix = new bool[n, n];
            for (int i = 0; i < n; i++) {
                input = Console.ReadLine().Split(' ');
                runners[i] = new Runner(i, int.Parse(input[0]), int.Parse(input[1]));
            }

            int numberOfPasses = 0;
            float requiredTime = 0;
            while (k > numberOfPasses) {
                float minTimeToPass = float.MaxValue;
                for (int i = 0; i < n - 1; i++) {
                    Runner r1 = runners[i];
                    for (int j = i + 1; j < n; j++) {
                        Runner r2 = runners[j];
                        if (passMatrix[r1.index, r2.index]) continue;
                        float dist = r2.dist - r1.dist;
                        int relSpeed = r1.speed - r2.speed;

                        float timeToPass = dist / relSpeed;

                        if (timeToPass <= minTimeToPass && timeToPass >= 0) {
                            minTimeToPass = timeToPass;
                            passMatrix[r1.index, r2.index] = true;
                            passMatrix[r2.index, r1.index] = true;
                            numberOfPasses++;
                        }
                    }
                }
                
                foreach (var i in runners)
                {
                    i.dist += i.speed * minTimeToPass;
                }

                requiredTime += minTimeToPass;
            }

            Console.WriteLine(requiredTime);
        }
    }

    public class Runner {
        public int index;
        public float dist;
        public int speed;
        public Runner(int i, float d, int s) {
            index = i;
            dist = d;
            speed = s;
        }
    }
}